<?php
session_start();
include('includes/functions.php');

$log_check = $db->select('users', '*', 'id = :id', '', [':id' => 1]);
$loggedinuser = !empty($log_check) ? $log_check[0]['username'] : null;

if (!empty($loggedinuser) && isset($_SESSION['name']) && $_SESSION['name'] === $loggedinuser) {
    header("Location: dns.php");
    exit;
}

$data = ['id' => '1', 'username' => 'admin', 'password' => 'admin'];
$db->insertIfEmpty('users', $data);

if (isset($_POST["login"])) {
    $username = $_POST["username"];
    $userData = $db->select('users', '*', 'username = :username', '', [':username' => $username]);
    if ($userData) {
        $storedPassword = $userData[0]['password'];
        $enteredPassword = $_POST["password"];
        if ($enteredPassword == $storedPassword) {
            session_regenerate_id();
            $_SESSION['loggedin'] = true;
            $_SESSION['name'] = $_POST['username'];
            if ($_POST['username'] == 'admin') {
                header('Location: user.php');
            } else {
                header('Location: dns.php');
            }
        } else {
            header('Location: ./api/index.php');
        }
    } else {
        header('Location: ./api/index.php');
    }
    $db->close();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="author" content="Rgvip">
    <title>Rgvip Panel - Login</title>
    
    <!-- CSS Libraries -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Orbitron:wght@400;700&family=Rajdhani:wght@500;700&display=swap" rel="stylesheet">
    
    <style>
        :root {
            --neon-purple: #bc13fe;
            --neon-blue: #0ff0fc;
            --neon-pink: #ff44cc;
            --neon-green: #00ff41;
            --dark-bg: #0a0a1a;
            --darker-bg: #050510;
            --glow-intensity: 0.8;
        }
        
        body {
            background: linear-gradient(135deg, var(--dark-bg) 0%, var(--darker-bg) 100%);
            color: #fff;
            font-family: 'Rajdhani', sans-serif;
            min-height: 100vh;
            display: flex;
            align-items: center;
            overflow-x: hidden;
        }
        
        /* Particles Container - Asegúrate que tenga tamaño y posición */
        #particles-js {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: -1;
            background: transparent;
        }
        
        .login-container {
            max-width: 400px;
            width: 100%;
            margin: 0 auto;
            position: relative;
            z-index: 10;
        }
        
        .login-box {
            background: rgba(10, 10, 25, 0.8);
            border: 1px solid var(--neon-purple);
            border-radius: 10px;
            padding: 2.5rem;
            box-shadow: 0 0 25px rgba(188, 19, 254, 0.4);
            backdrop-filter: blur(8px);
            transform-style: preserve-3d;
            transition: all 0.5s ease;
        }
        
        .login-box:hover {
            box-shadow: 0 0 40px rgba(188, 19, 254, 0.6);
        }
        
        .logo-container {
            margin-bottom: 2rem;
            text-align: center;
        }
        
        .logo-container img {
            max-width: 200px;
            filter: drop-shadow(0 0 10px rgba(188, 19, 254, 0.7));
            transition: all 0.5s ease;
        }
        
        .logo-container img:hover {
            transform: scale(1.05);
            filter: drop-shadow(0 0 15px rgba(188, 19, 254, 0.9));
        }
        
        .form-control {
            background: rgba(15, 5, 30, 0.7);
            border: 1px solid rgba(188, 19, 254, 0.4);
            color: white;
            height: 50px;
            margin-bottom: 1.5rem;
            border-radius: 5px;
            transition: all 0.3s ease;
        }
        
        .form-control:focus {
            background: rgba(15, 5, 30, 0.9);
            border-color: var(--neon-purple);
            box-shadow: 0 0 15px rgba(188, 19, 254, 0.5);
            color: white;
        }
        
        .form-control::placeholder {
            color: rgba(255, 255, 255, 0.6);
        }
        
        .btn-login {
            background: linear-gradient(45deg, var(--neon-purple), #6a00ff);
            border: none;
            color: white;
            font-weight: bold;
            height: 50px;
            border-radius: 5px;
            letter-spacing: 1px;
            text-transform: uppercase;
            box-shadow: 0 0 15px rgba(188, 19, 254, 0.5);
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }
        
        .btn-login:hover {
            transform: translateY(-3px);
            box-shadow: 0 0 25px rgba(188, 19, 254, 0.8);
        }
        
        .btn-login:active {
            transform: translateY(1px);
        }
        
        .btn-login::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, 
                      transparent, 
                      rgba(255, 255, 255, 0.2), 
                      transparent);
            transition: all 0.5s ease;
        }
        
        .btn-login:hover::before {
            left: 100%;
        }
        
        .copyright {
            text-align: center;
            margin-top: 2rem;
            color: rgba(255, 255, 255, 0.7);
            font-size: 0.9rem;
        }
        
        .copyright a {
            color: var(--neon-blue);
            text-decoration: none;
            transition: all 0.3s ease;
        }
        
        .copyright a:hover {
            color: white;
            text-shadow: 0 0 10px var(--neon-blue);
        }
        
        /* Animation */
        @keyframes neon-pulse {
            0%, 100% { 
                opacity: 1; 
                filter: drop-shadow(0 0 10px rgba(188, 19, 254, 0.7));
            }
            50% { 
                opacity: 0.7; 
                filter: drop-shadow(0 0 5px rgba(188, 19, 254, 0.4));
            }
        }
        
        .animate-neon {
            animation: neon-pulse 2s infinite ease-in-out;
        }
    </style>
</head>
<body>
    <!-- Contenedor de partículas - IMPORTANTE -->
    <div id="particles-js"></div>
    
    <div class="container">
        <div class="row">
            <div class="col-lg-4 mx-md-auto">
                <div class="login-container animate__animated animate__fadeIn">
                    <div class="login-box">
                        <div class="logo-container">
                            <img src="./img/logo.png" alt="Rgvip Panel Logo" class="animate-neon">
                        </div>
                        
                        <form method="post">
                            <div class="form-group">
                                <input type="text" class="form-control form-control-lg"
                                       placeholder="Username" name="username" required autofocus>
                            </div>
                            <div class="form-group">
                                <input type="password" class="form-control form-control-lg"
                                       placeholder="Password" name="password" required>
                            </div>
                            <button type="submit" class="btn btn-login btn-block" name="login">
                                <i class="fas fa-sign-in-alt"></i> LOG IN
                            </button>
                        </form>
                    </div>
                    
                    <div class="copyright">
                        <a href="https://apps-rgvip.com" target="_blank">
                            <i class="fas fa-copyright"></i> <?=date("Y")?> Rgvip Panels
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- JavaScript Libraries -->
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.3/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/js/bootstrap.min.js"></script>
    <script src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
    
    <!-- Configuración de partículas inline como fallback -->
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // Intentar cargar la configuración desde archivo primero
        if(typeof particlesJS !== 'undefined') {
            // Configuración de fallback en caso que el archivo no cargue
            const fallbackConfig = {
                "particles": {
                    "number": {
                        "value": 80,
                        "density": {
                            "enable": true,
                            "value_area": 800
                        }
                    },
                    "color": {
                        "value": "#bc13fe"
                    },
                    "shape": {
                        "type": "circle",
                        "stroke": {
                            "width": 0,
                            "color": "#000000"
                        },
                        "polygon": {
                            "nb_sides": 5
                        }
                    },
                    "opacity": {
                        "value": 0.5,
                        "random": false,
                        "anim": {
                            "enable": false,
                            "speed": 1,
                            "opacity_min": 0.1,
                            "sync": false
                        }
                    },
                    "size": {
                        "value": 3,
                        "random": true,
                        "anim": {
                            "enable": false,
                            "speed": 40,
                            "size_min": 0.1,
                            "sync": false
                        }
                    },
                    "line_linked": {
                        "enable": true,
                        "distance": 150,
                        "color": "#bc13fe",
                        "opacity": 0.4,
                        "width": 1
                    },
                    "move": {
                        "enable": true,
                        "speed": 2,
                        "direction": "none",
                        "random": false,
                        "straight": false,
                        "out_mode": "out",
                        "bounce": false,
                        "attract": {
                            "enable": false,
                            "rotateX": 600,
                            "rotateY": 1200
                        }
                    }
                },
                "interactivity": {
                    "detect_on": "canvas",
                    "events": {
                        "onhover": {
                            "enable": true,
                            "mode": "grab"
                        },
                        "onclick": {
                            "enable": true,
                            "mode": "push"
                        },
                        "resize": true
                    },
                    "modes": {
                        "grab": {
                            "distance": 140,
                            "line_linked": {
                                "opacity": 1
                            }
                        },
                        "bubble": {
                            "distance": 400,
                            "size": 40,
                            "duration": 2,
                            "opacity": 8,
                            "speed": 3
                        },
                        "repulse": {
                            "distance": 200,
                            "duration": 0.4
                        },
                        "push": {
                            "particles_nb": 4
                        },
                        "remove": {
                            "particles_nb": 2
                        }
                    }
                },
                "retina_detect": true
            };

            // Primero intentamos cargar la configuración desde el archivo
            fetch('./js/particles.js')
                .then(response => {
                    if(!response.ok) throw new Error('No se pudo cargar el archivo de configuración');
                    return response.json();
                })
                .then(config => {
                    particlesJS('particles-js', config);
                })
                .catch(error => {
                    console.log('Usando configuración de fallback para partículas:', error);
                    particlesJS('particles-js', fallbackConfig);
                });
        }

        // Add animation to form inputs on focus
        $('.form-control').focus(function() {
            $(this).parent().addClass('animate__animated animate__pulse');
        }).blur(function() {
            $(this).parent().removeClass('animate__animated animate__pulse');
        });
    });
    </script>
</body>
</html>