<?php
session_start();
include('includes/header.php');

// Conectar a la DB de códigos
$api_db_path = __DIR__.'/api/codes.db';
$api_db = new SQLite3($api_db_path);

if (isset($_POST['activar_cuenta'])) {
    $codigo = trim($_POST['codigo_activacion'] ?? '');

    if ($codigo === '') {
        echo "<div class='alert alert-danger'>Por favor ingresa un código de activación.</div>";
    } else {
        // Buscar el código en codes.db y que esté sin usar (estado = 0)
        $stmt = $api_db->prepare("SELECT * FROM codes WHERE codigo = :codigo AND estado = 0 LIMIT 1");
        $stmt->bindValue(':codigo', $codigo, SQLITE3_TEXT);
        $result = $stmt->execute();
        $datos = $result->fetchArray(SQLITE3_ASSOC);

        if (!$datos) {
            echo "<div class='alert alert-danger'>Código inválido o ya usado.</div>";
        } else {
            $mac = $datos['mac_address'];
            $dns_id = $datos['dns_id'];

            // Verificar duplicado
            $exists = $db->select('playlist', '*', "mac_address='$mac' AND dns_id='$dns_id'");
            if ($exists) {
                echo "<div class='alert alert-warning'>⚠️ Esta MAC ya tiene una cuenta en el mismo servidor DNS.</div>";
            } else {
                // Insertar en playlist
                $datos_playlist = [
                    'dns_id' => $dns_id,
                    'mac_address' => $mac,
                    'username' => $datos['username'],
                    'password' => $datos['password'],
                    'pin' => $datos['pin'],
                    'device_key' => $datos['device_key'] // Corregido: usar device_key de la consulta
                ];

                if ($db->insert('playlist', $datos_playlist)) {
                    // Marcar como usado SOLO si se insertó correctamente
                    $update = $api_db->prepare("UPDATE codes SET estado = 1 WHERE codigo = :codigo");
                    $update->bindValue(':codigo', $codigo, SQLITE3_TEXT);
                    $update->execute();
                    
                    echo "<div class='alert alert-success'>✅ Cuenta activada correctamente y código marcado como usado.</div>";
                } else {
                    echo "<div class='alert alert-danger'>Error al activar la cuenta.</div>";
                }
            }
        }
    }
}
?>

<div class="col-md-8 mx-auto mt-4">
    <div class="card-body">
        <div class="card bg-primary text-white">
            <div class="card-header card-header-warning">
                <center><h2><i class="icon icon-bullhorn"></i> Activar Cuenta</h2></center>
            </div>
            <div class="card-body">
                <form method="post">
                    <div class="form-group">
                        <label class="form-label">Código de Activación</label>
                        <input class="form-control" name="codigo_activacion" placeholder="Ingrese el código" type="text" required/>
                    </div>
                    <div class="form-group">
                        <center>
                            <button class="btn btn-success" name="activar_cuenta" type="submit">
                                <i class="icon icon-check"></i> Activar Cuenta
                            </button>
                        </center>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php include('includes/footer.php'); ?>